
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1305.C - Message 1305 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1305 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1305 message from the ZMsgBuf.
//
void Dec1305(tMSGBUF *ZMsgBuf, tMSG1304 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1305 message in the ZMsgBuf.
//
void Bld1305(tMSGBUF *ZMsgBuf, tMSG1305 *Msg)
{
 
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1305                           , ZMsgBuf, 2);     // message number
   PutShort  (2                              , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
}                                            

